/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.commands.PlaceCommandBuilder;
import org.betterx.bclib.util.BlocksHelper;

public class PlaceCommand {
    public static final String PLACE_COMMAND = "place";
    public static final String POOL = "pool";

    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)PLACE_COMMAND).requires(commandSourceStack -> commandSourceStack.m_6761_(2));
        new PlaceCommandBuilder().register(commandBuildContext, (LiteralArgumentBuilder<CommandSourceStack>)command);
        return (LiteralArgumentBuilder)bnContext.then((ArgumentBuilder)command);
    }

    private static boolean isEmpty(Level level, BoundingBox bb) {
        for (int x = bb.m_162395_(); x <= bb.m_162399_(); ++x) {
            for (int y = bb.m_162396_(); y <= bb.m_162400_(); ++y) {
                for (int z = bb.m_162398_(); z <= bb.m_162401_(); ++z) {
                    if (level.m_46859_(new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void replaceAir(Level level, BoundingBox bb) {
        BlocksHelper.forAllInBounds(bb, bp -> {
            if (level.m_8055_(bp).m_60713_(Blocks.f_50016_)) {
                level.m_7731_(bp, Blocks.f_50454_.m_49966_(), 3);
            }
        });
    }

    private static void removeLootTableSeed(Level level, BoundingBox bb) {
        BlocksHelper.forAllInBounds(bb, bp -> {
            BlockEntity patt22296$temp = level.m_7702_(bp);
            if (patt22296$temp instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity rnd = (RandomizableContainerBlockEntity)patt22296$temp;
                rnd.m_59626_(rnd.f_59605_, 0L);
            }
        });
    }

    static void fill(Level level, BoundingBox bb, BlockState blockState) {
        BlocksHelper.forAllInBounds(bb, bp -> level.m_7731_(bp, blockState, 3));
    }

    static void fillStructureVoid(Level level, BoundingBox bb) {
        PlaceCommand.fill(level, bb, Blocks.f_50454_.m_49966_());
    }

    private static void outline(Level level, BoundingBox bb, BlockState outlineState) {
        BlocksHelper.forOutlineInBounds(bb, bp -> level.m_7731_(bp, outlineState, 3));
    }

    private static BoundingBox adapt(BoundingBox bb, boolean border, boolean structureBlock) {
        if (border) {
            return bb.m_191961_(1);
        }
        if (structureBlock) {
            return new BoundingBox(bb.m_162395_(), bb.m_162396_(), bb.m_162398_(), bb.m_162399_() + 1, bb.m_162400_() + 1, bb.m_162401_() + 1);
        }
        return bb;
    }

    private static void createControlBlocks(CommandSourceStack stack, ResourceLocation location, BoundingBox bbNBT) {
        StructureBlockEntity entity;
        BlockPos structureBlockPos = new BlockPos(bbNBT.m_162395_() - 1, bbNBT.m_162396_() - 1, bbNBT.m_162398_() - 1);
        BlockPos commandBlockPos = new BlockPos(bbNBT.m_162395_() - 1, bbNBT.m_162396_() - 1, bbNBT.m_162398_());
        BlockPos buttonBlockPos = new BlockPos(bbNBT.m_162395_() - 1, bbNBT.m_162396_(), bbNBT.m_162398_());
        BlockState state = (BlockState)Blocks.f_50677_.m_49966_().m_61124_((Property)StructureBlock.f_57110_, (Comparable)StructureMode.SAVE);
        stack.m_81372_().m_7731_(structureBlockPos, state, 3);
        BlockEntity blockEntity = stack.m_81372_().m_7702_(structureBlockPos);
        if (blockEntity instanceof StructureBlockEntity) {
            entity = (StructureBlockEntity)blockEntity;
            entity.m_59876_(false);
            entity.m_59896_(false);
            entity.m_59881_(Mirror.NONE);
            entity.m_59883_(Rotation.NONE);
            entity.m_59898_(true);
            entity.m_59874_(location);
            entity.m_59885_(new BlockPos(1, 1, 1));
            entity.m_155797_(new Vec3i(bbNBT.m_71056_(), bbNBT.m_71057_(), bbNBT.m_71058_()));
        }
        state = (BlockState)Blocks.f_50272_.m_49966_().m_61124_((Property)CommandBlock.f_51793_, (Comparable)Direction.DOWN);
        stack.m_81372_().m_7731_(commandBlockPos, state, 3);
        blockEntity = stack.m_81372_().m_7702_(commandBlockPos);
        if (blockEntity instanceof CommandBlockEntity) {
            entity = (CommandBlockEntity)blockEntity;
            entity.m_59137_(false);
            entity.m_59135_(false);
            entity.m_6326_();
            entity.m_59141_().m_6102_();
            entity.m_59141_().m_6590_("fill ~1 ~1 ~ ~" + bbNBT.m_71056_() + " ~" + bbNBT.m_71057_() + " ~" + bbNBT.m_71058_() + " " + BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50454_) + " replace " + BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50016_));
        }
        state = (BlockState)((BlockState)Blocks.f_50251_.m_49966_().m_61124_((Property)ButtonBlock.f_54117_, (Comparable)Direction.EAST)).m_61124_((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR);
        stack.m_81372_().m_7731_(buttonBlockPos, state, 3);
    }

    static BoundingBox placeBlocks(CommandSourceStack stack, BlockPos pos, BlockPos searchDir, BlockInput blockInput, boolean structureBlock, boolean replaceAir, boolean preFillStructureVoid, ResourceLocation location, Function<BlockPos, BoundingBox> getBounds, BiConsumer<ServerLevel, BlockPos> generate) {
        BoundingBox bb;
        if (searchDir != null) {
            int tries;
            for (tries = 256; tries > 0 && !PlaceCommand.isEmpty((Level)stack.m_81372_(), PlaceCommand.adapt(getBounds.apply(pos), blockInput != null, structureBlock)); --tries) {
                pos = pos.m_121955_((Vec3i)searchDir);
            }
            if (tries <= 0) {
                stack.m_81352_((Component)Component.m_237113_((String)"Failed to find free space").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                return null;
            }
        }
        if (structureBlock) {
            pos = pos.m_7918_(1, 0, 1);
        }
        BoundingBox bbNBT = getBounds.apply(pos);
        if (blockInput != null) {
            bb = PlaceCommand.adapt(bbNBT, true, structureBlock);
            PlaceCommand.outline((Level)stack.m_81372_(), bb, blockInput.m_114669_());
            stack.m_288197_(() -> Component.m_237113_((String)("Placed border: " + bb.toString())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
        } else {
            bb = PlaceCommand.adapt(bbNBT, false, structureBlock);
        }
        if (preFillStructureVoid) {
            PlaceCommand.replaceAir((Level)stack.m_81372_(), bb);
        }
        generate.accept(stack.m_81372_(), pos);
        if (replaceAir) {
            PlaceCommand.replaceAir((Level)stack.m_81372_(), bbNBT);
        }
        PlaceCommand.removeLootTableSeed((Level)stack.m_81372_(), bbNBT);
        stack.m_288197_(() -> Component.m_237113_((String)("Placed NBT: " + bbNBT.toString())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
        if (structureBlock) {
            PlaceCommand.createControlBlocks(stack, location, bbNBT);
        }
        return bb;
    }

    public static BlockState setJigsawOrientation(boolean rollable, Player player, BlockPos pos, BlockState state) {
        int deltaY = player.m_146904_() - pos.m_123342_();
        state = deltaY < 2 && deltaY > -2 && rollable ? (BlockState)state.m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)player.m_6350_().m_122424_(), (Direction)Direction.UP)) : (deltaY < 0 ? (BlockState)state.m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)Direction.DOWN, (Direction)player.m_6350_().m_122424_())) : (BlockState)state.m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)Direction.UP, (Direction)player.m_6350_().m_122424_())));
        return state;
    }
}

